# task02

2-е домашнее задание для http://clojurecourse.by

## Usage

Реализуйте многопоточный сервер базы данных, принимающий на вход строковые sql-запросы, и возвращающий результат в виде EDN.

Проект task02 содержит заготовку этого сервера. Реализуйте недостающие части кода, отмеченные в тексте знаком :implement-me. Код должен соответствовать существующим тестам, запустите их командой 'lein test'.

Обратите внимание, что в project.clj некоторые неймспейсы помечены для компиляции:

    :aot [task02.Database task02.core]

    * Файл core.clj содержит класс task02.core и функцию main, которая загружает данные и запускает сервер.
    * Файл db.clj содержит заготовку базы данных, которую мы начали реализовывать в первом ДЗ. На этот раз данные можно изменять, удалять, добавлять.
    * Файл query.clj содержит функцию perform-query, которая выполняет разбор запроса и выполняет этот запрос. Запрос можно передавать в виде текстовой строки, как обычный sql-запрос.
    * Файл Database.clj используется для создания класса Database, который можно будет импортировать из любого java-проекта и использовать его.

    Для того, чтобы скомпилировать ваш проект и установить его в локальный maven-репозиторий? выполните команды 'lein compile; lein install'.

    Дополнительно разработан клиент нашей БД -- task02-java-client. Этот клиент написан на java. Обратите внимание, как в pom.xml импортируется наш проект task02:
    <dependency>
      <groupId>by.clojurecourse</groupId>
      <artifactId>task02</artifactId>
      <version>0.1.0</version>
    </dependency>

Обратите внимание также на библиотеку работы с EDN в java:

    <dependency>
      <groupId>us.bpsm</groupId>
      <artifactId>edn-java</artifactId>
      <version>0.4.4</version>
    </dependency>

    Для того, чтобы скомпилировать java-клиент, необходимо выполнить команду 'mvn -q compile'. Для того, чтобы запустить клиент, во-первых, запустите сервер базы данных командой lein repl, затем запустите клиент командой mvn -q exec:java -Dexec.mainClass="task02.Client" -Dexec.args="'select student'"

    Последний аргумент команды -- запрос к базе данных.

Для тех, кому это задание покажется слишком простым, дополнительно предлагается реализовать следующее.

1. Реализуйте команды создания и удаления таблиц.
2. Реализуйте многопоточный клиент к базе данных на Clojure. Протестируйте производительность сервера БД на клиенте, запущенном в 10 потоков.
